/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.utils.Guard;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class ReplicatePutJobSpectraS3Request
extends AbstractRequest {
    private final String bucketName;
    private final String requestPayload;
    private Priority priority;
    private long size = 0L;

    public ReplicatePutJobSpectraS3Request(String bucketName, String requestPayload) {
        this.bucketName = bucketName;
        this.requestPayload = requestPayload;
        this.getQueryParams().put("operation", "start_bulk_put");
        this.getQueryParams().put("replicate", null);
    }

    public ReplicatePutJobSpectraS3Request withPriority(Priority priority) {
        this.priority = priority;
        this.updateQueryParam("priority", priority);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/bucket/" + this.bucketName;
    }

    @Override
    public InputStream getStream() {
        if (Guard.isStringNullOrEmpty((String)this.requestPayload)) {
            return null;
        }
        byte[] stringBytes = this.requestPayload.getBytes(Charset.forName("UTF-8"));
        this.size = stringBytes.length;
        return new ByteArrayInputStream(stringBytes);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getRequestPayload() {
        return this.requestPayload;
    }

    public Priority getPriority() {
        return this.priority;
    }
}

