/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.BucketAclPermission;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutBucketAclForGroupSpectraS3Request
extends AbstractRequest {
    private final String bucketId;
    private final String groupId;
    private final BucketAclPermission permission;

    public PutBucketAclForGroupSpectraS3Request(String bucketId, UUID groupId, BucketAclPermission permission) {
        this.bucketId = bucketId;
        this.groupId = groupId.toString();
        this.permission = permission;
        this.updateQueryParam("bucket_id", bucketId);
        this.updateQueryParam("group_id", groupId);
        this.updateQueryParam("permission", permission);
    }

    public PutBucketAclForGroupSpectraS3Request(String bucketId, String groupId, BucketAclPermission permission) {
        this.bucketId = bucketId;
        this.groupId = groupId;
        this.permission = permission;
        this.updateQueryParam("bucket_id", bucketId);
        this.updateQueryParam("group_id", groupId);
        this.updateQueryParam("permission", permission);
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/bucket_acl";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public BucketAclPermission getPermission() {
        return this.permission;
    }
}

