/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.TargetReadPreferenceType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutAzureTargetReadPreferenceSpectraS3Request
extends AbstractRequest {
    private final String bucketId;
    private final TargetReadPreferenceType readPreference;
    private final String targetId;

    public PutAzureTargetReadPreferenceSpectraS3Request(String bucketId, TargetReadPreferenceType readPreference, UUID targetId) {
        this.bucketId = bucketId;
        this.readPreference = readPreference;
        this.targetId = targetId.toString();
        this.updateQueryParam("bucket_id", bucketId);
        this.updateQueryParam("read_preference", readPreference);
        this.updateQueryParam("target_id", targetId);
    }

    public PutAzureTargetReadPreferenceSpectraS3Request(String bucketId, TargetReadPreferenceType readPreference, String targetId) {
        this.bucketId = bucketId;
        this.readPreference = readPreference;
        this.targetId = targetId;
        this.updateQueryParam("bucket_id", bucketId);
        this.updateQueryParam("read_preference", readPreference);
        this.updateQueryParam("target_id", targetId);
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/azure_target_read_preference";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public TargetReadPreferenceType getReadPreference() {
        return this.readPreference;
    }

    public String getTargetId() {
        return this.targetId;
    }
}

