/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Quiesced;
import com.spectralogic.ds3client.models.ReservedTaskType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ModifyTapeDriveSpectraS3Request
extends AbstractRequest {
    private final String tapeDriveId;
    private Quiesced quiesced;
    private ReservedTaskType reservedTaskType;

    public ModifyTapeDriveSpectraS3Request(UUID tapeDriveId) {
        this.tapeDriveId = tapeDriveId.toString();
    }

    public ModifyTapeDriveSpectraS3Request(String tapeDriveId) {
        this.tapeDriveId = tapeDriveId;
    }

    public ModifyTapeDriveSpectraS3Request withQuiesced(Quiesced quiesced) {
        this.quiesced = quiesced;
        this.updateQueryParam("quiesced", quiesced);
        return this;
    }

    public ModifyTapeDriveSpectraS3Request withReservedTaskType(ReservedTaskType reservedTaskType) {
        this.reservedTaskType = reservedTaskType;
        this.updateQueryParam("reserved_task_type", reservedTaskType);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape_drive/" + this.tapeDriveId;
    }

    public String getTapeDriveId() {
        return this.tapeDriveId;
    }

    public Quiesced getQuiesced() {
        return this.quiesced;
    }

    public ReservedTaskType getReservedTaskType() {
        return this.reservedTaskType;
    }
}

