/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class IRODSUriUserInfo {
    private static final String ZONE_INDICATOR = ".";
    private static final String PASSWORD_INDICATOR = ":";
    private static final byte ESCAPE_INDICATOR = 37;
    private static final Set<Byte> USER_INFO_ALLOWED_CHARS;
    private final String user;
    private final String zone;
    private final String password;

    public static IRODSUriUserInfo instance(String user, String zone, String password) {
        return new IRODSUriUserInfo(user, zone, password);
    }

    public static IRODSUriUserInfo localInstance(String user, String password) {
        return new IRODSUriUserInfo(user, null, password);
    }

    public static IRODSUriUserInfo unauthenticatedInstance(String user, String zone) {
        return new IRODSUriUserInfo(user, zone, null);
    }

    public static IRODSUriUserInfo unauthenticatedLocalInstance(String user) {
        return new IRODSUriUserInfo(user, null, null);
    }

    static IRODSUriUserInfo fromString(String encodedStr) {
        if (encodedStr == null || encodedStr.isEmpty()) {
            return null;
        }
        int zIdx = encodedStr.indexOf(ZONE_INDICATOR);
        int pIdx = encodedStr.indexOf(PASSWORD_INDICATOR);
        String encodedUser = null;
        String encodedZone = null;
        String encodedPassword = null;
        if (zIdx < 0 && pIdx < 0) {
            encodedUser = encodedStr;
        } else if (zIdx < 0 && pIdx >= 0) {
            encodedUser = encodedStr.substring(0, pIdx);
            encodedPassword = encodedStr.substring(pIdx + 1);
        } else if (zIdx >= 0 && pIdx <= zIdx) {
            encodedUser = encodedStr.substring(0, zIdx);
            encodedZone = encodedStr.substring(zIdx + 1);
        } else {
            encodedUser = encodedStr.substring(0, zIdx);
            encodedZone = encodedStr.substring(zIdx + 1, pIdx);
            encodedPassword = encodedStr.substring(pIdx + 1);
        }
        return new IRODSUriUserInfo(IRODSUriUserInfo.decode(encodedUser), IRODSUriUserInfo.decode(encodedZone), IRODSUriUserInfo.decode(encodedPassword));
    }

    private static String emptyAsNull(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    private static String decode(String encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        byte[] encoded = encodedValue.getBytes(StandardCharsets.US_ASCII);
        ByteArrayOutputStream decoded = new ByteArrayOutputStream();
        for (int i = 0; i < encoded.length; ++i) {
            if (encoded[i] == 37) {
                int ud = Character.digit(encoded[++i], 16);
                int ld = Character.digit(encoded[++i], 16);
                decoded.write((ud << 4) + ld);
                continue;
            }
            decoded.write(encoded[i]);
        }
        return new String(decoded.toByteArray(), StandardCharsets.UTF_8);
    }

    private static String encode(String value) {
        byte[] decoded = value.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream encoded = new ByteArrayOutputStream();
        for (byte c : decoded) {
            if (USER_INFO_ALLOWED_CHARS.contains(c)) {
                encoded.write(c);
                continue;
            }
            String hex = Integer.toHexString(c & 0xFF).toUpperCase();
            byte[] digits = hex.getBytes(StandardCharsets.US_ASCII);
            encoded.write(37);
            encoded.write(digits, 0, digits.length);
        }
        return new String(encoded.toByteArray(), StandardCharsets.US_ASCII);
    }

    private IRODSUriUserInfo(String user, String zone, String password) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("must provide a user name");
        }
        this.user = user;
        this.zone = IRODSUriUserInfo.emptyAsNull(zone);
        this.password = IRODSUriUserInfo.emptyAsNull(password);
    }

    public String toString() {
        StringBuilder encoded = new StringBuilder();
        encoded.append(IRODSUriUserInfo.encode(this.user));
        if (this.zone != null) {
            encoded.append(ZONE_INDICATOR).append(IRODSUriUserInfo.encode(this.zone));
        }
        if (this.password != null) {
            encoded.append(PASSWORD_INDICATOR).append(IRODSUriUserInfo.encode(this.password));
        }
        return encoded.toString();
    }

    public String getUserName() {
        return this.user;
    }

    public String getZone() {
        return this.zone;
    }

    public String getPassword() {
        return this.password;
    }

    static {
        byte c;
        byte[] allowedMarks = new byte[]{45, 95, 33, 126, 42, 39, 40, 41, 59, 38, 61, 43, 36, 44};
        HashSet<Byte> chars = new HashSet<Byte>();
        for (c = 48; c <= 57; c = (byte)(c + 1)) {
            chars.add(c);
        }
        for (c = 97; c <= 122; c = (byte)(c + 1)) {
            chars.add(c);
        }
        for (c = 65; c <= 90; c = (byte)(c + 1)) {
            chars.add(c);
        }
        for (byte c2 : allowedMarks) {
            chars.add(c2);
        }
        USER_INFO_ALLOWED_CHARS = Collections.unmodifiableSet(chars);
    }
}

