/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import org.irods.jargon.core.transfer.FileRestartDataSegment;
import org.irods.jargon.core.transfer.FileRestartInfo;
import org.irods.jargon.core.transfer.FileRestartInfoIdentifier;
import org.irods.jargon.core.transfer.FileRestartManagementException;
import org.irods.jargon.core.transfer.RestartFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestartManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestartManager.class);

    public synchronized FileRestartInfo retrieveRestartAndBuildIfNotStored(FileRestartInfoIdentifier fileRestartInfoIdentifier, String localFilePath, int numberOfThreads) throws FileRestartManagementException {
        log.info("retrieveRestartAndBuildIfNotStored()");
        if (fileRestartInfoIdentifier == null) {
            throw new IllegalArgumentException("null fileRestartInfoIdentifier");
        }
        if (localFilePath == null || localFilePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty localFilePath");
        }
        FileRestartInfo info = this.retrieveRestart(fileRestartInfoIdentifier);
        if (info == null) {
            log.info("no restart saved, create and store a new one");
            info = new FileRestartInfo();
            info.setIrodsAbsolutePath(fileRestartInfoIdentifier.getAbsolutePath());
            info.setIrodsAccountIdentifier(fileRestartInfoIdentifier.getIrodsAccountIdentifier());
            info.setRestartType(fileRestartInfoIdentifier.getRestartType());
            info.setLocalAbsolutePath(localFilePath);
            for (int i = 0; i < numberOfThreads; ++i) {
                info.getFileRestartDataSegments().add(new FileRestartDataSegment(i));
            }
            this.storeRestart(info);
        }
        return info;
    }

    public abstract void updateSegment(FileRestartInfo var1, FileRestartDataSegment var2) throws FileRestartManagementException;

    public abstract FileRestartInfo incrementRestartAttempts(FileRestartInfo var1) throws RestartFailedException, FileRestartManagementException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLengthForSegment(FileRestartInfoIdentifier fileRestartInfoIdentifier, int threadNumber, long length) throws FileRestartManagementException {
        log.info("updateLengthForSegment()");
        if (fileRestartInfoIdentifier == null) {
            throw new IllegalArgumentException("null identifier");
        }
        AbstractRestartManager abstractRestartManager = this;
        synchronized (abstractRestartManager) {
            FileRestartInfo info = this.retrieveRestart(fileRestartInfoIdentifier);
            if (info == null) {
                throw new FileRestartManagementException("unable to find restart info");
            }
            if (info.getFileRestartDataSegments().size() - 1 < threadNumber) {
                throw new FileRestartManagementException("unable to locate thread number");
            }
            FileRestartDataSegment dataSegment = info.getFileRestartDataSegments().get(threadNumber);
            if (dataSegment.getThreadNumber() != threadNumber) {
                log.error("thread number in segment odos not match requested:{}", (Object)threadNumber);
                log.error("segment was:{}", (Object)dataSegment);
                throw new FileRestartManagementException("thread number mismatch");
            }
            dataSegment.setLength(dataSegment.getLength() + length);
            this.storeRestart(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOffsetForSegment(FileRestartInfoIdentifier fileRestartInfoIdentifier, int threadNumber, long offset) throws FileRestartManagementException {
        log.info("updateLenghtForSegment()");
        if (fileRestartInfoIdentifier == null) {
            throw new IllegalArgumentException("null identifier");
        }
        AbstractRestartManager abstractRestartManager = this;
        synchronized (abstractRestartManager) {
            FileRestartInfo info = this.retrieveRestart(fileRestartInfoIdentifier);
            if (info == null) {
                throw new FileRestartManagementException("unable to find restart info");
            }
            if (info.getFileRestartDataSegments().size() - 1 < threadNumber) {
                throw new FileRestartManagementException("unable to locate thread number");
            }
            FileRestartDataSegment dataSegment = info.getFileRestartDataSegments().get(threadNumber);
            dataSegment.setOffset(offset);
            dataSegment.setLength(0L);
            this.storeRestart(info);
        }
    }

    public abstract FileRestartInfoIdentifier storeRestart(FileRestartInfo var1) throws FileRestartManagementException;

    public abstract void deleteRestart(FileRestartInfoIdentifier var1) throws FileRestartManagementException;

    public abstract FileRestartInfo retrieveRestart(FileRestartInfoIdentifier var1) throws FileRestartManagementException;
}

