/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;

public class ModAccessControlInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "modAccessControlInp_PI";
    public static final int MOD_ACESS_CONTROL_API_NBR = 707;
    public static final String RECURSIVE_FLAG = "recursiveFlag";
    public static final String ACCESS_LEVEL = "accessLevel";
    public static final String USER_NAME = "userName";
    public static final String ZONE = "zone";
    public static final String PATH = "path";
    public static final String ADMIN = "admin:";
    public static final String READ_PERMISSION = "read";
    public static final String WRITE_PERMISSION = "write";
    public static final String OWN_PERMISSION = "own";
    public static final String INHERIT_PERMISSION = "inherit";
    public static final String NOINHERIT_PERMISSION = "noinherit";
    public static final String NULL_PERMISSION = "null";
    private final boolean recursive;
    private final String zone;
    private final String absolutePath;
    private final String userName;
    private final String permission;
    private final boolean adminMode;

    public static ModAccessControlInp instanceForSetPermission(boolean recursive, String zone, String absolutePath, String userName, String permission) {
        return new ModAccessControlInp(707, recursive, zone, absolutePath, userName, permission, false);
    }

    public static ModAccessControlInp instanceForSetPermissionInAdminMode(boolean recursive, String zone, String absolutePath, String userName, String permission) {
        return new ModAccessControlInp(707, recursive, zone, absolutePath, userName, permission, true);
    }

    public static ModAccessControlInp instanceForSetInheritOnACollection(boolean recursive, String zone, String absolutePath) {
        return new ModAccessControlInp(707, recursive, zone, absolutePath, "", INHERIT_PERMISSION, false);
    }

    public static ModAccessControlInp instanceForSetInheritOnACollectionInAdminMode(boolean recursive, String zone, String absolutePath) {
        return new ModAccessControlInp(707, recursive, zone, absolutePath, "", INHERIT_PERMISSION, true);
    }

    public static ModAccessControlInp instanceForSetNoInheritOnACollection(boolean recursive, String zone, String absolutePath) {
        return new ModAccessControlInp(707, recursive, zone, absolutePath, "", NOINHERIT_PERMISSION, false);
    }

    public static ModAccessControlInp instanceForSetNoInheritOnACollectionInAdminMode(boolean recursive, String zone, String absolutePath) {
        return new ModAccessControlInp(707, recursive, zone, absolutePath, "", NOINHERIT_PERMISSION, true);
    }

    private ModAccessControlInp(int apiNumber, boolean recursive, String zone, String absolutePath, String userName, String permission, boolean adminMode) {
        if (apiNumber <= 0) {
            throw new IllegalArgumentException("apiNumber is less than or equal to zero");
        }
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolute path");
        }
        if (userName == null) {
            throw new IllegalArgumentException("null userName");
        }
        if (permission == null || permission.isEmpty()) {
            throw new IllegalArgumentException("null or empty permission");
        }
        if (!(permission.equals(OWN_PERMISSION) || permission.equals(READ_PERMISSION) || permission.equals(WRITE_PERMISSION) || permission.equals(INHERIT_PERMISSION) || permission.equals(NOINHERIT_PERMISSION) || permission.equals(NULL_PERMISSION))) {
            throw new IllegalArgumentException("invalid permission");
        }
        if (permission.equals(INHERIT_PERMISSION) || permission.equals(NOINHERIT_PERMISSION)) {
            if (!userName.isEmpty()) {
                throw new IllegalArgumentException("userName cannot be specified if setting inherit/noinherit");
            }
        } else if (userName.isEmpty()) {
            throw new IllegalArgumentException("userName required");
        }
        this.setApiNumber(apiNumber);
        this.recursive = recursive;
        this.zone = zone;
        this.absolutePath = absolutePath;
        this.userName = userName;
        this.permission = permission;
        this.adminMode = adminMode;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        int recursiveVal = this.recursive ? 1 : 0;
        StringBuilder myPermission = new StringBuilder();
        if (this.adminMode) {
            myPermission.append(ADMIN);
            myPermission.append(this.permission);
        } else {
            myPermission.append(this.permission);
        }
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(RECURSIVE_FLAG, recursiveVal), new Tag(ACCESS_LEVEL, myPermission.toString()), new Tag(USER_NAME, this.userName), new Tag(ZONE, this.zone), new Tag(PATH, this.absolutePath)});
        return message;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public String getZone() {
        return this.zone;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPermission() {
        return this.permission;
    }
}

