/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthMethod;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UpdateUserRequest {
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="gender")
    private GenderEnum gender = null;
    @JsonProperty(value="lockStatus")
    private Integer lockStatus = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = null;
    @JsonProperty(value="expiration")
    private ObjectExpiration expiration = null;
    @JsonProperty(value="authMethods")
    private List<UserAuthMethod> authMethods = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="receiverLanguage")
    private String receiverLanguage = null;

    public UpdateUserRequest title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UpdateUserRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="User first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UpdateUserRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="User last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UpdateUserRequest gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(example="n", value="Gender")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public UpdateUserRequest lockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(value="DEPRECATED. User lock status: * `0` - locked * `1` - Web access allowed * `2` - Web and mobile access allowed")
    public Integer getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UpdateUserRequest isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @ApiModelProperty(example="false", value="User is locked: * `false` - unlocked * `true` - locked  Iser is locked and can not login anymore. (default: false)")
    public Boolean getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public UpdateUserRequest expiration(ObjectExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(value="Expiration date / time")
    public ObjectExpiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(ObjectExpiration expiration) {
        this.expiration = expiration;
    }

    public UpdateUserRequest authMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public UpdateUserRequest addAuthMethodsItem(UserAuthMethod authMethodsItem) {
        if (this.authMethods == null) {
            this.authMethods = new ArrayList<UserAuthMethod>();
        }
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @ApiModelProperty(value="Authentication methods: * `sql` * `active_directory` * `radius` * `openid`")
    public List<UserAuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public UpdateUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="john.doe@email.com", value="Email (not used)")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UpdateUserRequest phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="Phone Number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public UpdateUserRequest receiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
        return this;
    }

    @ApiModelProperty(example="de-DE", value="IETF language tag")
    public String getReceiverLanguage() {
        return this.receiverLanguage;
    }

    public void setReceiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateUserRequest updateUserRequest = (UpdateUserRequest)o;
        return Objects.equals(this.title, updateUserRequest.title) && Objects.equals(this.firstName, updateUserRequest.firstName) && Objects.equals(this.lastName, updateUserRequest.lastName) && Objects.equals((Object)this.gender, (Object)updateUserRequest.gender) && Objects.equals(this.lockStatus, updateUserRequest.lockStatus) && Objects.equals(this.isLocked, updateUserRequest.isLocked) && Objects.equals(this.expiration, updateUserRequest.expiration) && Objects.equals(this.authMethods, updateUserRequest.authMethods) && Objects.equals(this.email, updateUserRequest.email) && Objects.equals(this.phone, updateUserRequest.phone) && Objects.equals(this.receiverLanguage, updateUserRequest.receiverLanguage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.firstName, this.lastName, this.gender, this.lockStatus, this.isLocked, this.expiration, this.authMethods, this.email, this.phone, this.receiverLanguage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateUserRequest {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    receiverLanguage: ").append(this.toIndentedString(this.receiverLanguage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        M("m"),
        F("f"),
        N("n");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String text) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

