/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateOAuthClientRequest {
    @JsonProperty(value="clientName")
    private String clientName = null;
    @JsonProperty(value="grantTypes")
    private List<String> grantTypes = new ArrayList<String>();
    @JsonProperty(value="clientId")
    private String clientId = null;
    @JsonProperty(value="clientSecret")
    private String clientSecret = null;
    @JsonProperty(value="redirectUris")
    private List<String> redirectUris = null;
    @JsonProperty(value="accessTokenValidity")
    private Integer accessTokenValidity = null;
    @JsonProperty(value="refreshTokenValidity")
    private Integer refreshTokenValidity = null;

    public CreateOAuthClientRequest clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name, which is shown at the client configuration and authorization.")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public CreateOAuthClientRequest grantTypes(List<String> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public CreateOAuthClientRequest addGrantTypesItem(String grantTypesItem) {
        this.grantTypes.add(grantTypesItem);
        return this;
    }

    @ApiModelProperty(example="[\"password\"]", required=true, value="Authorized grant types cf. [RFC 6749](https://tools.ietf.org/html/rfc6749)")
    public List<String> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public CreateOAuthClientRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @ApiModelProperty(value="ID of the OAuth client")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreateOAuthClientRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @ApiModelProperty(value="Secret, which client uses at authentication.")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public CreateOAuthClientRequest redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public CreateOAuthClientRequest addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @ApiModelProperty(value="URIs, to which a user is redirected after authorization.")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public CreateOAuthClientRequest accessTokenValidity(Integer accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
        return this;
    }

    @ApiModelProperty(value="Validity of the access token in seconds.")
    public Integer getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public void setAccessTokenValidity(Integer accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
    }

    public CreateOAuthClientRequest refreshTokenValidity(Integer refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
        return this;
    }

    @ApiModelProperty(value="Validity of the refresh token in seconds.")
    public Integer getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public void setRefreshTokenValidity(Integer refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOAuthClientRequest createOAuthClientRequest = (CreateOAuthClientRequest)o;
        return Objects.equals(this.clientName, createOAuthClientRequest.clientName) && Objects.equals(this.grantTypes, createOAuthClientRequest.grantTypes) && Objects.equals(this.clientId, createOAuthClientRequest.clientId) && Objects.equals(this.clientSecret, createOAuthClientRequest.clientSecret) && Objects.equals(this.redirectUris, createOAuthClientRequest.redirectUris) && Objects.equals(this.accessTokenValidity, createOAuthClientRequest.accessTokenValidity) && Objects.equals(this.refreshTokenValidity, createOAuthClientRequest.refreshTokenValidity);
    }

    public int hashCode() {
        return Objects.hash(this.clientName, this.grantTypes, this.clientId, this.clientSecret, this.redirectUris, this.accessTokenValidity, this.refreshTokenValidity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOAuthClientRequest {\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    grantTypes: ").append(this.toIndentedString(this.grantTypes)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    accessTokenValidity: ").append(this.toIndentedString(this.accessTokenValidity)).append("\n");
        sb.append("    refreshTokenValidity: ").append(this.toIndentedString(this.refreshTokenValidity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

