/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.Customer;
import ch.cyberduck.core.sds.io.swagger.client.model.CustomerAttributes;
import ch.cyberduck.core.sds.io.swagger.client.model.CustomerList;
import ch.cyberduck.core.sds.io.swagger.client.model.NewCustomerRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.NewCustomerResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateCustomerRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateCustomerResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.UserList;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class ProvisioningApi {
    private ApiClient apiClient;

    public ProvisioningApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProvisioningApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteCustomer(Long customerId, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling deleteCustomer");
        }
        if (xSdsServiceToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsServiceToken' when calling deleteCustomer");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteCustomerAttributes(Long customerId, String key, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling deleteCustomerAttributes");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteCustomerAttributes");
        }
        if (xSdsServiceToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsServiceToken' when calling deleteCustomerAttributes");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}/customerAttributes/{key}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Customer getCustomer(Long customerId, String xSdsServiceToken, Boolean includeAttributes, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling getCustomer");
        }
        if (xSdsServiceToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsServiceToken' when calling getCustomer");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_attributes", includeAttributes));
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Customer> localVarReturnType = new GenericType<Customer>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserList getCustomerUsers(Long customerId, String xSdsServiceToken, Integer offset, Integer limit, String filter, String sort, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling getCustomerUsers");
        }
        if (xSdsServiceToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsServiceToken' when calling getCustomerUsers");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}/users".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserList> localVarReturnType = new GenericType<UserList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomerList getCustomers(String xSdsServiceToken, Integer offset, Integer limit, String filter, String sort, Boolean includeAttributes, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsServiceToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsServiceToken' when calling getCustomers");
        }
        String localVarPath = "/v4/provisioning/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_attributes", includeAttributes));
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CustomerList> localVarReturnType = new GenericType<CustomerList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NewCustomerResponse newCustomerRequest(NewCustomerRequest body, String xSdsServiceToken, String xSdsDateFormat) throws ApiException {
        NewCustomerRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling newCustomerRequest");
        }
        if (xSdsServiceToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsServiceToken' when calling newCustomerRequest");
        }
        String localVarPath = "/v4/provisioning/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NewCustomerResponse> localVarReturnType = new GenericType<NewCustomerResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Customer setAllCustomerAttributes(Long customerId, CustomerAttributes body, String xSdsServiceToken, String xSdsDateFormat) throws ApiException {
        CustomerAttributes localVarPostBody = body;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling setAllCustomerAttributes");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setAllCustomerAttributes");
        }
        if (xSdsServiceToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsServiceToken' when calling setAllCustomerAttributes");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}/customerAttributes".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Customer> localVarReturnType = new GenericType<Customer>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Customer setCustomerAttributes(Long customerId, CustomerAttributes body, String xSdsServiceToken, String xSdsDateFormat) throws ApiException {
        CustomerAttributes localVarPostBody = body;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling setCustomerAttributes");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setCustomerAttributes");
        }
        if (xSdsServiceToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsServiceToken' when calling setCustomerAttributes");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}/customerAttributes".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Customer> localVarReturnType = new GenericType<Customer>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateCustomerResponse updateCustomer(Long customerId, UpdateCustomerRequest body, String xSdsServiceToken, String xSdsDateFormat) throws ApiException {
        UpdateCustomerRequest localVarPostBody = body;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling updateCustomer");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCustomer");
        }
        if (xSdsServiceToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsServiceToken' when calling updateCustomer");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UpdateCustomerResponse> localVarReturnType = new GenericType<UpdateCustomerResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

