/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.ChangeGroupMembersRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateGroupRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.Group;
import ch.cyberduck.core.sds.io.swagger.client.model.GroupList;
import ch.cyberduck.core.sds.io.swagger.client.model.GroupUserList;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleList;
import ch.cyberduck.core.sds.io.swagger.client.model.RoomTreeDataList;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateGroupRequest;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class GroupsApi {
    private ApiClient apiClient;

    public GroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Group addGroupMembers(Long groupId, ChangeGroupMembersRequest body, String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        ChangeGroupMembersRequest localVarPostBody = body;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling addGroupMembers");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addGroupMembers");
        }
        String localVarPath = "/v4/groups/{group_id}/users".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<Group> localVarReturnType = new GenericType<Group>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Group createGroup(CreateGroupRequest body, String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        CreateGroupRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createGroup");
        }
        String localVarPath = "/v4/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<Group> localVarReturnType = new GenericType<Group>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteGroup(Long groupId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling deleteGroup");
        }
        String localVarPath = "/v4/groups/{group_id}".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Group deleteGroupMembers(Long groupId, ChangeGroupMembersRequest body, String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        ChangeGroupMembersRequest localVarPostBody = body;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling deleteGroupMembers");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteGroupMembers");
        }
        String localVarPath = "/v4/groups/{group_id}/users".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<Group> localVarReturnType = new GenericType<Group>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Group getGroup(Long groupId, String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroup");
        }
        String localVarPath = "/v4/groups/{group_id}".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<Group> localVarReturnType = new GenericType<Group>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleList getGroupRoles(Long groupId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroupRoles");
        }
        String localVarPath = "/v4/groups/{group_id}/roles".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RoleList> localVarReturnType = new GenericType<RoleList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoomTreeDataList getGroupRooms(Long groupId, Integer offset, Integer limit, String filter, String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroupRooms");
        }
        String localVarPath = "/v4/groups/{group_id}/rooms".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RoomTreeDataList> localVarReturnType = new GenericType<RoomTreeDataList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GroupUserList getGroupUsers(Long groupId, Integer offset, Integer limit, String filter, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroupUsers");
        }
        String localVarPath = "/v4/groups/{group_id}/users".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<GroupUserList> localVarReturnType = new GenericType<GroupUserList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public GroupList getGroups(Integer offset, Integer limit, String filter, String sort, String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<GroupList> localVarReturnType = new GenericType<GroupList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Group updateGroup(Long groupId, UpdateGroupRequest body, String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        UpdateGroupRequest localVarPostBody = body;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling updateGroup");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateGroup");
        }
        String localVarPath = "/v4/groups/{group_id}".replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<Group> localVarReturnType = new GenericType<Group>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

