/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSMissingFileKeysSchedulerFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class SDSEncryptionBulkFeature
implements Bulk<Void> {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSEncryptionBulkFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Void pre(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        try {
            switch (type) {
                case download: {
                    break;
                }
                default: {
                    for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
                        if (!this.nodeid.isEncrypted(entry.getKey().remote)) continue;
                        TransferStatus status = entry.getValue();
                        FileKey fileKey = TripleCryptConverter.toSwaggerFileKey(Crypto.generateFileKey());
                        ObjectWriter writer = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).writerFor(FileKey.class);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        writer.writeValue((OutputStream)out, (Object)fileKey);
                        status.setFilekey(ByteBuffer.wrap(out.toByteArray()));
                    }
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public void post(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        switch (type) {
            case download: {
                break;
            }
            default: {
                if (!PreferencesFactory.get().getBoolean("sds.encryption.missingkeys.upload") || !this.session.userAccount().isEncryptionEnabled()) break;
                SDSMissingFileKeysSchedulerFeature background = new SDSMissingFileKeysSchedulerFeature(this.session, this.nodeid);
                for (TransferItem file : files.keySet()) {
                    if (!this.nodeid.isEncrypted(file.remote)) continue;
                    background.operate((PasswordCallback)callback, file.remote);
                }
            }
        }
    }

    public Bulk<Void> withDelete(Delete delete) {
        return this;
    }
}

