/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSCopyFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.shared.DefaultCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SDSDelegatingCopyFeature
implements Copy {
    private final SDSSession session;
    private final SDSCopyFeature proxy;
    private final DefaultCopyFeature copy;

    public SDSDelegatingCopyFeature(SDSSession session, SDSNodeIdProvider nodeid, SDSCopyFeature proxy) {
        this.session = session;
        this.proxy = proxy;
        this.copy = new DefaultCopyFeature((Session)session);
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (this.proxy.isSupported(source, target)) {
            return this.proxy.copy(source, target, status, callback);
        }
        this.setFileKey(status);
        return this.copy.copy(source, target, status, callback);
    }

    private void setFileKey(TransferStatus status) throws BackgroundException {
        FileKey fileKey = TripleCryptConverter.toSwaggerFileKey(Crypto.generateFileKey());
        ObjectWriter writer = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).writerFor(FileKey.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            writer.writeValue((OutputStream)out, (Object)fileKey);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        status.setFilekey(ByteBuffer.wrap(out.toByteArray()));
    }

    public boolean isRecursive(Path source, Path target) {
        if (this.proxy.isSupported(source, target)) {
            return this.proxy.isRecursive(source, target);
        }
        return this.copy.isRecursive(source, target);
    }

    public boolean isSupported(Path source, Path target) {
        if (this.proxy.isSupported(source, target)) {
            return true;
        }
        return this.copy.isSupported(source, target);
    }

    public Copy withTarget(Session<?> session) {
        this.proxy.withTarget(session);
        return this;
    }
}

