/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.InteractiveTerminalPromptReader;
import ch.cyberduck.cli.TerminalProgressListener;
import ch.cyberduck.cli.TerminalPromptReader;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;

public class TerminalTransferErrorCallback
implements TransferErrorCallback {
    private final TerminalProgressListener console = new TerminalProgressListener();
    private final TerminalPromptReader prompt;

    public TerminalTransferErrorCallback() {
        this.prompt = new InteractiveTerminalPromptReader();
    }

    public TerminalTransferErrorCallback(TerminalPromptReader prompt) {
        this.prompt = prompt;
    }

    @Override
    public boolean prompt(TransferItem item, BackgroundException failure) throws BackgroundException {
        StringAppender appender = new StringAppender();
        appender.append(failure.getMessage());
        appender.append(failure.getDetail());
        this.console.message(appender.toString());
        if (!this.prompt.prompt(LocaleFactory.localizedString("Continue", "Credentials"))) {
            throw failure;
        }
        return true;
    }
}

