/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.Console;
import ch.cyberduck.cli.InteractiveTerminalPromptReader;
import ch.cyberduck.cli.TerminalPromptReader;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;

public class TerminalPasswordCallback
implements PasswordCallback {
    private final Console console = new Console();
    private final TerminalPromptReader prompt;

    public TerminalPasswordCallback() {
        this.prompt = new InteractiveTerminalPromptReader();
    }

    public TerminalPasswordCallback(TerminalPromptReader prompt) {
        this.prompt = prompt;
    }

    @Override
    public Credentials prompt(Host bookmark, String title, String reason, LoginOptions options) throws LoginCanceledException {
        this.console.printf("%n%s", new StringAppender().append(title).append(reason));
        try {
            char[] input = this.console.readPassword("%n%s: ", options.getPasswordPlaceholder());
            Credentials credentials = new Credentials();
            credentials.setPassword(String.valueOf(input));
            if (options.save && options.keychain) {
                credentials.setSaved(this.prompt.prompt(LocaleFactory.get().localize("Save password", "Credentials")));
            } else {
                credentials.setSaved(options.save);
            }
            return credentials;
        }
        catch (ConnectionCanceledException e) {
            throw new LoginCanceledException(e);
        }
    }
}

