/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.TerminalOptionsBuilder;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledPasswordStore;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.KeychainLoginService;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;

public class TerminalLoginService
extends KeychainLoginService {
    private final CommandLine input;

    public TerminalLoginService(CommandLine input, LoginCallback prompt) {
        super(prompt, input.hasOption(TerminalOptionsBuilder.Params.nokeychain.name()) ? new DisabledPasswordStore() : PasswordStoreFactory.get());
        this.input = input;
    }

    @Override
    public void validate(Host bookmark, String message, LoginOptions options) throws LoginCanceledException, LoginFailureException {
        Credentials credentials = bookmark.getCredentials();
        if (this.input.hasOption(TerminalOptionsBuilder.Params.username.name())) {
            credentials.setUsername(this.input.getOptionValue(TerminalOptionsBuilder.Params.username.name()));
        }
        if (this.input.hasOption(TerminalOptionsBuilder.Params.password.name())) {
            credentials.setPassword(this.input.getOptionValue(TerminalOptionsBuilder.Params.password.name()));
        }
        if (this.input.hasOption(TerminalOptionsBuilder.Params.identity.name())) {
            credentials.setIdentity(LocalFactory.get(this.input.getOptionValue(TerminalOptionsBuilder.Params.identity.name())));
        }
        if (StringUtils.isNotBlank((CharSequence)credentials.getUsername()) && StringUtils.isNotBlank((CharSequence)credentials.getPassword())) {
            return;
        }
        super.validate(bookmark, message, options);
    }
}

