/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.Console;
import ch.cyberduck.cli.InteractiveTerminalPromptReader;
import ch.cyberduck.cli.TerminalPasswordCallback;
import ch.cyberduck.cli.TerminalPromptReader;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class TerminalLoginCallback
extends TerminalPasswordCallback
implements LoginCallback {
    private final Console console = new Console();
    private final TerminalPromptReader prompt;

    public TerminalLoginCallback() {
        this(new InteractiveTerminalPromptReader());
    }

    public TerminalLoginCallback(TerminalPromptReader prompt) {
        super(prompt);
        this.prompt = prompt;
    }

    @Override
    public void warn(Host bookmark, String title, String reason, String defaultButton, String cancelButton, String preference) throws ConnectionCanceledException {
        this.console.printf("%n%s", reason);
        if (!this.prompt.prompt(String.format("%s (y) or %s (n): ", defaultButton, cancelButton))) {
            throw new LoginCanceledException();
        }
    }

    @Override
    public Credentials prompt(Host bookmark, String username, String title, String reason, LoginOptions options) throws LoginCanceledException {
        this.console.printf("%n%s", new StringAppender().append(title).append(reason));
        try {
            Credentials credentials = new Credentials(username);
            if (options.user) {
                String user;
                if (StringUtils.isBlank((CharSequence)credentials.getUsername())) {
                    user = this.console.readLine("%n%s: ", options.getUsernamePlaceholder());
                    credentials.setUsername(user);
                } else {
                    user = this.console.readLine("%n%s (%s): ", options.getUsernamePlaceholder(), credentials.getUsername());
                    if (StringUtils.isNotBlank((CharSequence)user)) {
                        credentials.setUsername(user);
                    }
                }
                this.console.printf("Login as %s", credentials.getUsername());
            }
            if (options.password) {
                char[] input = this.console.readPassword("%n%s: ", options.getPasswordPlaceholder());
                credentials.setPassword(String.valueOf(input));
                Arrays.fill(input, ' ');
            }
            if (options.save && options.keychain) {
                credentials.setSaved(this.prompt.prompt(LocaleFactory.get().localize("Save password", "Credentials")));
            } else {
                credentials.setSaved(options.save);
            }
            return credentials;
        }
        catch (ConnectionCanceledException e) {
            throw new LoginCanceledException(e);
        }
    }

    @Override
    public Local select(Local identity) throws LoginCanceledException {
        return identity;
    }
}

