/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.SingleTransferItemFinder;
import ch.cyberduck.cli.TerminalAction;
import ch.cyberduck.cli.TransferItemFinder;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.transfer.TransferItem;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class GlobTransferItemFinder
implements TransferItemFinder {
    private static final Logger log = Logger.getLogger(GlobTransferItemFinder.class);

    @Override
    public Set<TransferItem> find(CommandLine input, TerminalAction action, Path remote) throws AccessDeniedException {
        Local directory;
        String path;
        if (input.getOptionValues(action.name()).length == 2 && StringUtils.containsAny((CharSequence)(path = input.getOptionValues(action.name())[1]), (char[])new char[]{'*', '?'}) && (directory = LocalFactory.get(FilenameUtils.getFullPath((String)path))).isDirectory()) {
            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher(String.format("glob:%s", FilenameUtils.getName((String)path)));
            HashSet<TransferItem> items = new HashSet<TransferItem>();
            for (Local file : directory.list((Filter<String>)new NullFilter<String>(){

                @Override
                public boolean accept(String file) {
                    try {
                        return matcher.matches(Paths.get(file, new String[0]));
                    }
                    catch (InvalidPathException e) {
                        log.warn((Object)String.format("Failure obtaining path for file %s", file));
                        return false;
                    }
                }
            })) {
                items.add(new TransferItem(new Path(remote, file.getName(), EnumSet.of(AbstractPath.Type.file)), file));
            }
            return items;
        }
        return new SingleTransferItemFinder().find(input, action, remote);
    }
}

