/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import java.io.IOException;
import java.util.List;

public class SFTPDeleteFeature
implements Delete {
    private final SFTPSession session;

    public SFTPDeleteFeature(SFTPSession session) {
        this.session = session;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            if (!file.isFile() && !file.isSymbolicLink()) continue;
            callback.delete(file);
            try {
                this.session.sftp().remove(file.getAbsolute());
            }
            catch (IOException e) {
                throw new SFTPExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
        for (Path file : files) {
            if (!file.isDirectory() || file.isSymbolicLink()) continue;
            callback.delete(file);
            try {
                this.session.sftp().removeDir(file.getAbsolute());
            }
            catch (IOException e) {
                throw new SFTPExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }

    public boolean isRecursive() {
        return false;
    }
}

