/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.irods.IRODSAttributesFinderFeature;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import ch.cyberduck.core.transfer.TransferStatus;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.io.IRODSFile;

public class IRODSDirectoryFeature
implements Directory<Void> {
    private final IRODSSession session;

    public IRODSDirectoryFeature(IRODSSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
            IRODSFile f = fs.getIRODSFileFactory().instanceIRODSFile(folder.getAbsolute());
            fs.mkdir(f, false);
            return new Path(folder.getParent(), folder.getName(), folder.getType(), new IRODSAttributesFinderFeature(this.session).find(folder));
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
    }

    public IRODSDirectoryFeature withWriter(Write<Void> writer) {
        return this;
    }
}

