/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.spectra.SpectraBulkService;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.spectra.SpectraWriteFeature;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class SpectraTouchFeature
implements Touch {
    private final SpectraSession session;
    private final S3WriteFeature writer;

    public SpectraTouchFeature(SpectraSession session) {
        this.session = session;
        this.writer = new SpectraWriteFeature(session);
    }

    public Path touch(Path file, TransferStatus transferStatus) throws BackgroundException {
        SpectraBulkService bulk = new SpectraBulkService(this.session);
        TransferStatus status = new TransferStatus();
        bulk.pre(Transfer.Type.upload, (Map)Collections.singletonMap(new TransferItem(file), status.length(0L)), (ConnectionCallback)new DisabledConnectionCallback());
        HttpResponseOutputStream out = this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback());
        new DefaultStreamCloser().close((OutputStream)out);
        S3Object metadata = (S3Object)out.getStatus();
        return new Path(file.getParent(), file.getName(), file.getType(), new S3AttributesFinderFeature((S3Session)this.session).toAttributes((StorageObject)metadata));
    }

    public boolean isSupported(Path workdir) {
        return !workdir.isRoot();
    }

    public SpectraTouchFeature withWriter(Write writer) {
        return this;
    }
}

