/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.users.DbxUserUsersRequests;
import com.dropbox.core.v2.users.SpaceAllocation;
import com.dropbox.core.v2.users.SpaceUsage;
import java.util.EnumSet;

public class DropboxQuotaFeature
implements Quota {
    private final DropboxSession session;

    public DropboxQuotaFeature(DropboxSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        try {
            SpaceUsage usage = new DbxUserUsersRequests((DbxRawClientV2)this.session.getClient()).getSpaceUsage();
            SpaceAllocation allocation = usage.getAllocation();
            if (allocation.isIndividual()) {
                return new Quota.Space(Long.valueOf(usage.getUsed()), Long.valueOf(allocation.getIndividualValue().getAllocated()));
            }
            if (allocation.isTeam()) {
                return new Quota.Space(Long.valueOf(usage.getUsed()), Long.valueOf(allocation.getTeamValue().getAllocated()));
            }
            return new Quota.Space(Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE));
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to read attributes of {0}", e, new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)));
        }
    }
}

