/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.openstack.SwiftAttributesFinderFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.openstack.SwiftWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.OutputStream;

public class SwiftTouchFeature
implements Touch<StorageObject> {
    final PathContainerService containerService = new PathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;
    private Write<StorageObject> writer;

    public SwiftTouchFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
        this.writer = new SwiftWriteFeature(session, regionService);
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        status.setLength(0L);
        StatusOutputStream out = this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback());
        new DefaultStreamCloser().close((OutputStream)out);
        StorageObject metadata = (StorageObject)out.getStatus();
        return new Path(file.getParent(), file.getName(), file.getType(), new SwiftAttributesFinderFeature(this.session, this.regionService).toAttributes(metadata));
    }

    public boolean isSupported(Path workdir) {
        return !workdir.isRoot();
    }

    public Touch<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

