/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoPathCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Vault;

public class CryptoFindFeature
implements Find {
    private final Session<?> session;
    private final Find delegate;
    private final Vault vault;
    private Cache<Path> cache = PathCache.empty();

    public CryptoFindFeature(Session<?> session, Find delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public boolean find(Path file) throws BackgroundException {
        try {
            return this.delegate.withCache((Cache)new CryptoPathCache(this.cache)).find(this.vault.encrypt(this.session, file, file.isDirectory()));
        }
        catch (NotfoundException e) {
            return false;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoFindFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

