/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Set;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveJsonObject;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;

public class OneDriveUploadSession
extends OneDriveJsonObject {
    private final OneDriveAPI api;
    private URL uploadUrl;
    private ZonedDateTime expirationDateTime;
    private String[] nextExpectedRanges;

    public OneDriveUploadSession(OneDriveAPI api, JsonObject json) {
        super(json);
        this.api = api;
    }

    public OneDriveAPI getApi() {
        return this.api;
    }

    public URL getUploadUrl() {
        return this.uploadUrl;
    }

    public ZonedDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public String[] getNextExpectedRanges() {
        return this.nextExpectedRanges;
    }

    public String getNextExpectedRange() {
        if (this.nextExpectedRanges.length == 0) {
            return null;
        }
        return this.nextExpectedRanges[0];
    }

    public OneDriveUploadSession getUploadStatus() throws IOException {
        OneDriveJsonRequest request = new OneDriveJsonRequest(this.getUploadUrl(), "GET");
        OneDriveJsonResponse response = request.sendRequest(this.api.getExecutor());
        JsonObject jsonObject = response.getContent();
        response.close();
        return new OneDriveUploadSession(this.api, jsonObject);
    }

    public OneDriveJsonObject uploadFragment(String contentRange, byte[] content) throws IOException {
        OneDriveJsonRequest request = new OneDriveJsonRequest(this.getUploadUrl(), "PUT"){

            @Override
            protected void addAuthorizationHeader(RequestExecutor executor, Set<RequestHeader> headers) {
            }
        };
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Range", String.format("bytes %s", contentRange));
        OneDriveJsonResponse response = (OneDriveJsonResponse)request.sendRequest(this.getApi().getExecutor(), new ByteArrayInputStream(content));
        JsonObject jsonObject = response.getContent();
        response.close();
        if (response.getResponseCode() == 202) {
            return new OneDriveUploadSession(this.getApi(), jsonObject);
        }
        if (response.getResponseCode() == 201 || response.getResponseCode() == 200) {
            return OneDriveFile.parseJson(this.api, jsonObject);
        }
        return null;
    }

    public void cancelUpload() throws IOException {
        OneDriveJsonRequest request = new OneDriveJsonRequest(this.getUploadUrl(), "DELETE"){

            @Override
            protected void addAuthorizationHeader(RequestExecutor executor, Set<RequestHeader> headers) {
            }
        };
        OneDriveJsonResponse response = request.sendRequest(this.api.getExecutor());
        response.close();
    }

    @Override
    protected void parseMember(JsonObject.Member member) {
        super.parseMember(member);
        try {
            String memberName;
            JsonValue value = member.getValue();
            switch (memberName = member.getName()) {
                case "uploadUrl": {
                    this.uploadUrl = new URL(value.asString());
                    break;
                }
                case "expirationDateTime": {
                    this.expirationDateTime = ZonedDateTime.parse(value.asString());
                    break;
                }
                case "nextExpectedRanges": {
                    this.parseNextExpectedRanges(value.asArray());
                }
            }
        }
        catch (ParseException | MalformedURLException e) {
            throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
        }
    }

    private void parseNextExpectedRanges(JsonArray jsonValues) {
        this.nextExpectedRanges = new String[jsonValues.size()];
        for (int i = 0; i < this.nextExpectedRanges.length; ++i) {
            this.nextExpectedRanges[i] = jsonValues.get(i).asString();
        }
    }
}

