/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.input.NullInputStream;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveRequest;
import org.nuxeo.onedrive.client.OneDriveResponse;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveUploadSession;
import org.nuxeo.onedrive.client.QueryStringBuilder;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveFile
extends OneDriveItem {
    public OneDriveFile(OneDriveAPI api) {
        super(api);
    }

    public OneDriveFile(OneDriveAPI api, OneDriveDrive drive, String resourceIdentifier, OneDriveItem.ItemIdentifierType itemIdentifierType) {
        super(api, drive, resourceIdentifier, itemIdentifierType);
    }

    public OneDriveFile(OneDriveAPI api, OneDriveFolder folder, String resourceIdentifier, OneDriveItem.ItemIdentifierType itemIdentifierType) {
        super(api, folder, resourceIdentifier, itemIdentifierType);
    }

    public Metadata create(String mimeType) throws IOException {
        URL url = this.getContentURL().build(this.getApi().getBaseURL());
        OneDriveRequest request = new OneDriveRequest(url, "PUT");
        request.addHeader("Content-Type", mimeType);
        OneDriveResponse response = (OneDriveResponse)request.sendRequest(this.getApi().getExecutor(), (InputStream)new NullInputStream(0L));
        OneDriveJsonResponse jsonResponse = new OneDriveJsonResponse(response.getResponseCode(), response.getResponseMessage(), response.getLocation(), response.getContent());
        JsonObject jsonObject = jsonResponse.getContent();
        response.close();
        return OneDriveFile.parseJson(this.getApi(), jsonObject);
    }

    @Override
    public Metadata getMetadata(OneDriveExpand ... expands) throws IOException {
        QueryStringBuilder query = new QueryStringBuilder().set("expand", expands);
        URL url = this.getMetadataURL().build(this.getApi().getBaseURL(), query, new Object[0]);
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        return new Metadata(response.getContent());
    }

    public InputStream download() throws IOException {
        URL url = this.getContentURL().build(this.getApi().getBaseURL());
        OneDriveRequest request = new OneDriveRequest(url, "GET");
        OneDriveResponse response = (OneDriveResponse)request.sendRequest(this.getApi().getExecutor());
        return response.getContent();
    }

    public InputStream download(String range) throws IOException {
        URL url = this.getContentURL().build(this.getApi().getBaseURL());
        OneDriveRequest request = new OneDriveRequest(url, "GET");
        request.addHeader("Range", String.format("bytes=%s", range));
        request.addHeader("Accept-Encoding", "identity");
        OneDriveResponse response = (OneDriveResponse)request.sendRequest(this.getApi().getExecutor());
        return response.getContent();
    }

    public URLTemplate getContentURL() {
        return new URLTemplate(this.getActionPath("content"));
    }

    public URLTemplate getUploadSessionURL() {
        String action = this.getApi().isGraphConnection() ? "createUploadSession" : "oneDrive.createUploadSession";
        return new URLTemplate(this.getActionPath(action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneDriveUploadSession createUploadSession() throws IOException {
        URL url = this.getUploadSessionURL().build(this.getApi().getBaseURL());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "POST");
        try (OneDriveJsonResponse jsonResponse = (OneDriveJsonResponse)request.sendRequest(this.getApi().getExecutor(), (InputStream)new NullInputStream(0L));){
            OneDriveUploadSession oneDriveUploadSession = new OneDriveUploadSession(this.getApi(), jsonResponse.getContent());
            return oneDriveUploadSession;
        }
    }

    public static Metadata parseJson(OneDriveAPI api, JsonObject nextObject) {
        OneDriveFile file;
        String id = nextObject.get("id").asString();
        OneDriveDrive drive = new OneDriveDrive(api, nextObject.get("parentReference").asObject().get("driveId").asString());
        OneDriveFile oneDriveFile = file = new OneDriveFile(api, drive, id, OneDriveItem.ItemIdentifierType.Id);
        oneDriveFile.getClass();
        return oneDriveFile.new Metadata(nextObject);
    }

    public class Metadata
    extends OneDriveItem.Metadata {
        private String cTag;
        private String mimeType;
        private String downloadUrl;
        private String crc32Hash;
        private String sha1Hash;

        public Metadata(JsonObject json) {
            super(OneDriveFile.this, json);
        }

        public String getCTag() {
            return this.cTag;
        }

        public String getVersion() {
            return this.cTag == null ? null : this.cTag.substring(this.cTag.lastIndexOf(44) + 1);
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public String getCrc32Hash() {
            return this.crc32Hash;
        }

        public String getSha1Hash() {
            return this.sha1Hash;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("cTag".equals(memberName)) {
                    this.cTag = value.asString();
                } else if ("@content.downloadUrl".equals(memberName)) {
                    this.downloadUrl = value.asString();
                } else if ("file".equals(memberName)) {
                    Metadata.parseMember(value.asObject(), this::parseFileMember);
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }

        private void parseFileMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("mimeType".equals(memberName)) {
                this.mimeType = value.asString();
            } else if ("hashes".equals(memberName)) {
                Metadata.parseMember(value.asObject(), this::parseHashesMember);
            }
        }

        private void parseHashesMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("crc32Hash".equals(memberName)) {
                this.crc32Hash = value.asString();
            } else if ("sha1Hash".equals(memberName)) {
                this.sha1Hash = value.asString();
            }
        }

        @Override
        public OneDriveFile getResource() {
            return OneDriveFile.this;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public Metadata asFile() {
            return this;
        }
    }
}

