/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;

public class OneDriveCopyOperation {
    private final JsonObject jsonObject = new JsonObject();

    public void rename(String newName) {
        this.jsonObject.add("name", newName);
    }

    public void copy(OneDriveFolder newParent) {
        JsonObject parentReference = new JsonObject();
        OneDriveDrive rootDrive = newParent.getDrive();
        if (null != rootDrive) {
            parentReference.add("driveId", newParent.getDrive().getItemIdentifier());
            parentReference.add("id", newParent.getItemIdentifier());
        } else if (OneDriveItem.ItemIdentifierType.Path == newParent.getItemIdentifierType()) {
            parentReference.add("path", newParent.getFullyQualifiedPath());
        }
        this.jsonObject.add("parentReference", (JsonValue)parentReference);
    }

    JsonObject build() {
        return this.jsonObject;
    }
}

