/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultFoundListCanceledException;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import org.apache.log4j.Logger;

public class VaultFinderListProgressListener
extends IndexedListProgressListener {
    private static final Logger log = Logger.getLogger(VaultFinderListProgressListener.class);
    private final VaultLookupListener listener;

    public VaultFinderListProgressListener(VaultLookupListener listener) {
        this.listener = listener;
    }

    @Override
    public void message(String message) {
    }

    @Override
    public void visit(AttributedList<Path> list, int index, Path file) throws ConnectionCanceledException {
        Path directory = file.getParent();
        if ("masterkey.cryptomator".equals(file.getName())) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found master key %s", file));
            }
            try {
                Vault vault = this.listener.load(directory, "masterkey.cryptomator", DefaultVaultRegistry.DEFAULT_PEPPER);
                if (vault.equals(Vault.DISABLED)) {
                    return;
                }
                throw new VaultFoundListCanceledException(vault, list);
            }
            catch (VaultUnlockCancelException vaultUnlockCancelException) {
                // empty catch block
            }
        }
    }
}

