/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.serializer.PathDictionary;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class DefaultHomeFinderService
implements Home {
    protected final Path DEFAULT_HOME = new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
    private final Session<?> session;

    public DefaultHomeFinderService(Session session) {
        this.session = session;
    }

    @Override
    public Path find() throws BackgroundException {
        Host host = this.session.getHost();
        if (host.getWorkdir() != null) {
            return new PathDictionary().deserialize(host.getWorkdir().serialize(SerializerFactory.get()));
        }
        String path = host.getDefaultPath();
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return this.find(this.DEFAULT_HOME, path);
        }
        return this.DEFAULT_HOME;
    }

    @Override
    public Path find(Path root, String path) {
        if (path.startsWith(String.valueOf('/'))) {
            String normalized;
            return new Path(normalized, (normalized = this.normalize(path, true)).equals(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.directory));
        }
        if (path.startsWith("~")) {
            return new Path(String.format("%s%s%s", root.getAbsolute(), Character.valueOf('/'), this.normalize(StringUtils.removeStart((String)StringUtils.removeStart((String)path, (String)"~"), (String)String.valueOf('/')), false)), EnumSet.of(AbstractPath.Type.directory));
        }
        return new Path(String.format("%s%s%s", root.getAbsolute(), Character.valueOf('/'), this.normalize(path, false)), EnumSet.of(AbstractPath.Type.directory));
    }

    protected String normalize(String input, boolean absolute) {
        return PathNormalizer.normalize(StringUtils.replace((String)input, (String)String.valueOf("\\"), (String)String.valueOf('/')), absolute);
    }
}

