/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.dd;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.serializer.Writer;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.io.IOUtils;

public class PlistWriter<S extends Serializable>
implements Writer<S> {
    @Override
    public void write(Collection<S> collection, Local file) throws AccessDeniedException {
        NSArray list = new NSArray(collection.size());
        int i = 0;
        for (Serializable bookmark : collection) {
            list.setValue(i, bookmark.serialize(SerializerFactory.get()));
            ++i;
        }
        String content = list.toXMLPropertyList();
        OutputStream out = file.getOutputStream(false);
        try {
            IOUtils.write((String)content, (OutputStream)out, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new AccessDeniedException(String.format("Cannot create file %s", file.getAbsolute()), e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Override
    public void write(S item, Local file) throws AccessDeniedException {
        String content = ((NSDictionary)item.serialize(SerializerFactory.get())).toXMLPropertyList();
        OutputStream out = file.getOutputStream(false);
        try {
            IOUtils.write((String)content, (OutputStream)out, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new AccessDeniedException(String.format("Cannot create file %s", file.getAbsolute()), e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

