/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.io.SegmentingOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class MemorySegementingOutputStream
extends SegmentingOutputStream {
    private static final Logger log = Logger.getLogger(MemorySegementingOutputStream.class);
    private final OutputStream proxy;
    private final ByteArrayOutputStream buffer;
    private final Integer threshold;
    private final AtomicBoolean close = new AtomicBoolean();

    public MemorySegementingOutputStream(OutputStream proxy, Integer threshold) {
        this(proxy, threshold, new ByteArrayOutputStream(threshold));
    }

    public MemorySegementingOutputStream(OutputStream proxy, Integer threshold, ByteArrayOutputStream buffer) {
        super(proxy, (long)threshold, buffer);
        this.proxy = proxy;
        this.buffer = buffer;
        this.threshold = threshold;
    }

    @Override
    public void flush() throws IOException {
        byte[] content = this.buffer.toByteArray();
        this.buffer.reset();
        for (int offset = 0; offset < content.length; offset += this.threshold.intValue()) {
            int len = Math.min(this.threshold, content.length - offset);
            byte[] bytes = Arrays.copyOfRange(content, offset, offset + len);
            if (len < this.threshold) {
                this.write(bytes);
                continue;
            }
            this.proxy.write(bytes);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.close.get()) {
            log.warn((Object)String.format("Skip double close of stream %s", new Object[]{this}));
            return;
        }
        try {
            if (this.buffer.size() > 0) {
                this.proxy.write(this.buffer.toByteArray());
            }
            this.buffer.reset();
            super.close();
        }
        finally {
            this.close.set(true);
        }
    }
}

