/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.io.Buffer;
import ch.cyberduck.core.local.LocalTouchFactory;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import org.apache.commons.io.input.NullInputStream;
import org.apache.log4j.Logger;

public class FileBuffer
implements Buffer {
    private static final Logger log = Logger.getLogger(FileBuffer.class);
    private final Local temporary;
    private RandomAccessFile file;
    private Long length = 0L;

    public FileBuffer() {
        this(TemporaryFileServiceFactory.get().create(new AlphanumericRandomStringService().random()));
    }

    public FileBuffer(Local temporary) {
        this.temporary = temporary;
    }

    @Override
    public synchronized int write(byte[] chunk, Long offset) throws IOException {
        RandomAccessFile file = this.random();
        file.seek(offset);
        file.write(chunk, 0, chunk.length);
        this.length = Math.max(this.length, file.length());
        return chunk.length;
    }

    @Override
    public synchronized int read(byte[] chunk, Long offset) throws IOException {
        RandomAccessFile file = this.random();
        if (offset < file.length()) {
            file.seek(offset);
            if ((long)chunk.length + offset > file.length()) {
                return file.read(chunk, 0, (int)(file.length() - offset));
            }
            return file.read(chunk, 0, chunk.length);
        }
        NullInputStream nullStream = new NullInputStream(this.length.longValue());
        if (nullStream.available() > 0) {
            nullStream.skip(offset.longValue());
            return nullStream.read(chunk, 0, chunk.length);
        }
        return -1;
    }

    @Override
    public synchronized Long length() {
        return this.length;
    }

    @Override
    public void truncate(Long length) {
        this.length = length;
        if (this.temporary.exists()) {
            try {
                RandomAccessFile file = this.random();
                if (length < file.length()) {
                    file.setLength(length);
                }
            }
            catch (IOException e) {
                log.warn((Object)String.format("Failure truncating file %s to %d", this.temporary, length));
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public synchronized void close() {
        block11: {
            this.length = 0L;
            if (this.temporary.exists()) {
                RandomAccessFile file = this.random();
                file.close();
                try {
                    this.temporary.delete();
                    this.file = null;
                }
                catch (AccessDeniedException | NotfoundException e) {
                    log.warn((Object)String.format("Failure removing temporary file %s for buffer %s. Schedule for delete on exit.", this.temporary, this));
                    Paths.get(this.temporary.getAbsolute(), new String[0]).toFile().deleteOnExit();
                }
                break block11;
                catch (IOException e) {
                    try {
                        log.error((Object)String.format("Failure closing buffer %s", this));
                    }
                    catch (Throwable throwable) {
                        try {
                            this.temporary.delete();
                            this.file = null;
                        }
                        catch (AccessDeniedException | NotfoundException e2) {
                            log.warn((Object)String.format("Failure removing temporary file %s for buffer %s. Schedule for delete on exit.", this.temporary, this));
                            Paths.get(this.temporary.getAbsolute(), new String[0]).toFile().deleteOnExit();
                        }
                        throw throwable;
                    }
                    try {
                        this.temporary.delete();
                        this.file = null;
                    }
                    catch (AccessDeniedException | NotfoundException e3) {
                        log.warn((Object)String.format("Failure removing temporary file %s for buffer %s. Schedule for delete on exit.", this.temporary, this));
                        Paths.get(this.temporary.getAbsolute(), new String[0]).toFile().deleteOnExit();
                    }
                }
            }
        }
    }

    protected synchronized RandomAccessFile random() throws IOException {
        if (null == this.file) {
            try {
                LocalTouchFactory.get().touch(this.temporary);
            }
            catch (AccessDeniedException e) {
                throw new IOException(e);
            }
            this.file = new RandomAccessFile(this.temporary.getAbsolute(), "rw");
            this.file.seek(0L);
        }
        return this.file;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileBuffer{");
        sb.append("temporary=").append(this.temporary);
        sb.append('}');
        return sb.toString();
    }
}

