/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;

public abstract class AbstractChecksumCompute
implements ChecksumCompute {
    public Checksum compute(String data, TransferStatus status) throws ChecksumException {
        try {
            return this.compute(new ByteArrayInputStream(Hex.decodeHex((char[])data.toCharArray())), status);
        }
        catch (DecoderException e) {
            throw new ChecksumException(LocaleFactory.localizedString("Checksum failure", "Error"), e.getMessage(), e);
        }
    }

    protected byte[] digest(String algorithm, InputStream in) throws ChecksumException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ChecksumException(LocaleFactory.localizedString("Checksum failure", "Error"), e.getMessage(), e);
        }
        try {
            int bytesRead;
            byte[] buffer = new byte[16384];
            while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                md.update(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new ChecksumException(LocaleFactory.localizedString("Checksum failure", "Error"), e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return md.digest();
    }

    protected InputStream normalize(InputStream in, TransferStatus status) throws ChecksumException {
        try {
            InputStream bounded = status.getLength() > 0L ? new BoundedInputStream(in, status.getOffset() + status.getLength()) : in;
            return status.getOffset() > 0L ? StreamCopier.skip(bounded, status.getOffset()) : bounded;
        }
        catch (BackgroundException e) {
            throw new ChecksumException(LocaleFactory.localizedString("Checksum failure", "Error"), e.getMessage(), e);
        }
    }
}

