/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.log4j.Logger;

public class LRUCache<Key, Value> {
    private static final Logger log = Logger.getLogger(LRUCache.class);
    private final Cache<Key, Value> delegate;

    public static <Key, Value> LRUCache<Key, Value> usingLoader(Function<Key, Value> loader) {
        return LRUCache.usingLoader(loader, -1L, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> usingLoader(Function<Key, Value> loader, long maximumSize) {
        return LRUCache.usingLoader(loader, maximumSize, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> usingLoader(Function<Key, Value> loader, long maximumSize, long expireDuration) {
        return new LRUCache<Key, Value>(loader, maximumSize, expireDuration);
    }

    public static <Key, Value> LRUCache<Key, Value> build() {
        return LRUCache.build(-1L, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> build(long maximumSize) {
        return LRUCache.build(maximumSize, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> build(long maximumSize, long expireDuration) {
        return new LRUCache<Key, Value>(null, maximumSize, expireDuration);
    }

    private LRUCache(final Function<Key, Value> loader, long maximumSize, long expireDuration) {
        CacheBuilder builder = CacheBuilder.newBuilder().removalListener(new RemovalListener<Key, Value>(){

            public void onRemoval(RemovalNotification<Key, Value> notification) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Removed %s from cache with cause %s", notification.getKey(), notification.getCause()));
                }
            }
        });
        if (maximumSize > 0L) {
            builder.maximumSize(maximumSize);
        }
        if (expireDuration > 0L) {
            builder.expireAfterAccess(expireDuration, TimeUnit.MILLISECONDS);
        }
        this.delegate = loader != null ? builder.build(new CacheLoader<Key, Value>(){

            public Value load(Key key) {
                return loader.apply(key);
            }
        }) : builder.build();
    }

    public Value get(Key key) throws UncheckedExecutionException {
        if (this.delegate instanceof LoadingCache) {
            return (Value)((LoadingCache)this.delegate).getUnchecked(key);
        }
        return (Value)this.delegate.getIfPresent(key);
    }

    public void forEach(BiConsumer<Key, Value> function) {
        this.delegate.asMap().forEach(function);
    }

    public void put(Key key, Value value) {
        this.delegate.put(key, value);
    }

    public void remove(Key key) {
        this.delegate.invalidate(key);
    }

    public boolean contains(Key key) {
        return null != this.delegate.getIfPresent(key);
    }
}

