/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Credentials
implements Comparable<Credentials> {
    private String user = "";
    private String password = "";
    private String token = "";
    private Local identity;
    private String certificate;
    private boolean persist = PreferencesFactory.get().getBoolean("connection.login.keychain");
    private boolean passed;

    public Credentials() {
    }

    public Credentials(Credentials copy) {
        this.user = copy.user;
        this.password = copy.password;
        this.token = copy.token;
        this.identity = copy.identity;
        this.certificate = copy.certificate;
        this.persist = copy.persist;
        this.passed = copy.passed;
    }

    public Credentials(String user) {
        this.user = user;
    }

    public Credentials(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public Credentials(String user, String password, String token) {
        this.user = user;
        this.password = password;
        this.token = token;
    }

    public String getUsername() {
        return this.user;
    }

    public void setUsername(String user) {
        this.user = user;
        this.passed = false;
    }

    public Credentials withUsername(String user) {
        this.user = user;
        this.passed = false;
        return this;
    }

    public String getPassword() {
        if (StringUtils.isEmpty((CharSequence)this.password) && this.isAnonymousLogin()) {
            return PreferencesFactory.get().getProperty("connection.login.anon.pass");
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.passed = false;
    }

    public Credentials withPassword(String password) {
        this.password = password;
        this.passed = false;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
        this.passed = false;
    }

    public Credentials withToken(String token) {
        this.token = token;
        this.passed = false;
        return this;
    }

    public boolean isSaved() {
        return this.persist;
    }

    public void setSaved(boolean saved) {
        this.persist = saved;
    }

    public Credentials withSaved(boolean saved) {
        this.persist = saved;
        return this;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    public boolean isAnonymousLogin() {
        if (StringUtils.isEmpty((CharSequence)this.user)) {
            return false;
        }
        return PreferencesFactory.get().getProperty("connection.login.anon.name").equals(this.user);
    }

    public boolean isPasswordAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.password);
    }

    public boolean isTokenAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.token);
    }

    public boolean isPublicKeyAuthentication() {
        if (null == this.identity) {
            return false;
        }
        return this.identity.exists();
    }

    public Credentials withIdentity(Local file) {
        this.identity = file;
        this.passed = false;
        return this;
    }

    public Local getIdentity() {
        return this.identity;
    }

    public void setIdentity(Local file) {
        this.identity = file;
        this.passed = false;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public boolean isCertificateAuthentication() {
        return null != this.certificate;
    }

    public boolean validate(Protocol protocol, LoginOptions options) {
        return protocol.validate(this, options);
    }

    @Override
    public int compareTo(Credentials o) {
        if (null == this.user && null == o.user) {
            return 0;
        }
        if (null == this.user) {
            return -1;
        }
        if (null == o.user) {
            return 1;
        }
        return this.user.compareTo(o.user);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Credentials)) {
            return false;
        }
        Credentials that = (Credentials)o;
        return Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password) && Objects.equals(this.token, that.token) && Objects.equals(this.identity, that.identity) && Objects.equals(this.certificate, that.certificate);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.password, this.token, this.identity, this.certificate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Credentials{");
        sb.append("user='").append(this.user).append('\'');
        sb.append(", token='").append(this.token).append('\'');
        sb.append(", identity=").append(this.identity);
        sb.append('}');
        return sb.toString();
    }
}

