/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxListService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Search;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.SearchMatch;
import com.dropbox.core.v2.files.SearchMode;
import com.dropbox.core.v2.files.SearchResult;
import java.util.EnumSet;
import java.util.List;
import org.apache.log4j.Logger;

public class DropboxSearchFeature
implements Search {
    private static final Logger log = Logger.getLogger(DropboxListService.class);
    private final DropboxSession session;
    private final DropboxAttributesFinderFeature attributes;

    public DropboxSearchFeature(DropboxSession session) {
        this.session = session;
        this.attributes = new DropboxAttributesFinderFeature(session);
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        try {
            SearchResult result;
            AttributedList list = new AttributedList();
            long start = 0L;
            do {
                result = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).searchBuilder(workdir.isRoot() ? "" : workdir.getAbsolute(), regex.toPattern().pattern()).withMode(SearchMode.FILENAME).withStart(Long.valueOf(start)).start();
                List matches = result.getMatches();
                for (SearchMatch match : matches) {
                    EnumSet<AbstractPath.Type> type;
                    Metadata metadata = match.getMetadata();
                    if (metadata instanceof FileMetadata) {
                        type = EnumSet.of(AbstractPath.Type.file);
                    } else if (metadata instanceof FolderMetadata) {
                        type = EnumSet.of(AbstractPath.Type.directory);
                    } else {
                        log.warn((Object)String.format("Skip file %s", metadata));
                        return null;
                    }
                    list.add((Referenceable)new Path(metadata.getPathDisplay(), type, this.attributes.convert(metadata)));
                    listener.chunk(workdir, list);
                }
                start = result.getStart();
            } while (result.getMore());
            return list;
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to read attributes of {0}", e, workdir);
        }
    }

    public boolean isRecursive() {
        return true;
    }

    public Search withCache(Cache<Path> cache) {
        return this;
    }
}

