/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.dropbox.DropboxDeleteFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import java.util.Collections;

public class DropboxCopyFeature
implements Copy {
    private final DropboxSession session;

    public DropboxCopyFeature(DropboxSession session) {
        this.session = session;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (status.isExists()) {
                new DropboxDeleteFeature(this.session).delete(Collections.singletonList(target), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
            }
            new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).copy(source.getAbsolute(), target.getAbsolute());
            return target;
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }

    public Copy withTarget(Session<?> session) {
        return this;
    }
}

