/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.handler.ETagResponseHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;

public class DAVWriteFeature
extends AbstractHttpWriteFeature<String>
implements Write<String> {
    private static final Logger log = Logger.getLogger(DAVWriteFeature.class);
    private final DAVSession session;
    private final boolean expect;

    public DAVWriteFeature(DAVSession session) {
        this(session, PreferencesFactory.get().getBoolean("webdav.expect-continue"));
    }

    public DAVWriteFeature(DAVSession session, boolean expect) {
        super((Session)session);
        this.session = session;
        this.expect = expect;
    }

    public DAVWriteFeature(DAVSession session, Find finder, AttributesFinder attributes, boolean expect) {
        super(finder, attributes);
        this.session = session;
        this.expect = expect;
    }

    public HttpResponseOutputStream<String> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ArrayList<Header> headers = new ArrayList<Header>();
        if (status.isAppend()) {
            HttpRange range = HttpRange.withStatus((TransferStatus)status);
            String header = String.format("bytes %d-%d/%d", range.getStart(), range.getEnd(), status.getOffset() + status.getLength());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Add range header %s for file %s", header, file));
            }
            headers.add((Header)new BasicHeader("Content-Range", header));
        }
        if (this.expect && status.getLength() > 0L) {
            headers.add((Header)new BasicHeader("Expect", "100-continue"));
        }
        return this.write(file, headers, status);
    }

    private HttpResponseOutputStream<String> write(final Path file, final List<Header> headers, final TransferStatus status) throws BackgroundException {
        DelayedHttpEntityCallable<String> command = new DelayedHttpEntityCallable<String>(){

            public String call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    return (String)((DAVClient)((Object)DAVWriteFeature.this.session.getClient())).put(new DAVPathEncoder().encode(file), (HttpEntity)entity, headers, (ResponseHandler)new ETagResponseHandler());
                }
                catch (SardineException e) {
                    throw new DAVExceptionMappingService().map("Upload {0} failed", e, file);
                }
                catch (IOException e) {
                    throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public boolean temporary() {
        return true;
    }

    public boolean random() {
        return true;
    }

    public ChecksumCompute checksum(Path file) {
        return new DisabledChecksumCompute();
    }
}

