/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import com.github.sardine.DavResource;
import com.github.sardine.impl.SardineException;
import com.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.xml.namespace.QName;

public class DAVTimestampFeature
extends DefaultTimestampFeature
implements Timestamp {
    private final DAVSession session;
    public static final QName LAST_MODIFIED_DEFAULT_NAMESPACE = SardineUtil.createQNameWithDefaultNamespace((String)"lastmodified");
    public static final QName LAST_MODIFIED_CUSTOM_NAMESPACE = SardineUtil.createQNameWithCustomNamespace((String)"lastmodified");
    public static final QName LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE = SardineUtil.createQNameWithCustomNamespace((String)"lastmodified_server");

    public DAVTimestampFeature(DAVSession session) {
        this.session = session;
    }

    public void setTimestamp(Path file, Long modified) throws BackgroundException {
        try {
            List resources = ((DAVClient)((Object)this.session.getClient())).propfind(new DAVPathEncoder().encode(file), 1, Collections.singleton(SardineUtil.createQNameWithDefaultNamespace((String)"getlastmodified")));
            Iterator iterator = resources.iterator();
            if (iterator.hasNext()) {
                DavResource resource = (DavResource)iterator.next();
                HashMap<QName, String> props = new HashMap<QName, String>();
                if (resource.getModified() != null) {
                    props.put(LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE, new RFC1123DateFormatter().format(resource.getModified(), TimeZone.getTimeZone("UTC")));
                }
                props.put(LAST_MODIFIED_CUSTOM_NAMESPACE, new RFC1123DateFormatter().format(modified.longValue(), TimeZone.getTimeZone("UTC")));
                ((DAVClient)((Object)this.session.getClient())).patch(new DAVPathEncoder().encode(file), props);
            }
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
    }
}

