/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import org.apache.log4j.Logger;

public class VaultRegistryMoveFeature
implements Move {
    private static final Logger log = Logger.getLogger(VaultRegistryMoveFeature.class);
    private final Session<?> session;
    private final Move proxy;
    private final DefaultVaultRegistry registry;

    public VaultRegistryMoveFeature(Session<?> session, Move proxy, DefaultVaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Path move(Path source, Path target, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        Vault vault = this.registry.find(this.session, source);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Move %s to %s inside vault %s", source, target, vault));
        }
        return vault.getFeature(this.session, Move.class, this.proxy).move(source, target, status, callback, connectionCallback);
    }

    @Override
    public boolean isRecursive(Path source, Path target) {
        try {
            if (this.registry.find(this.session, source, false).equals(this.registry.find(this.session, target, false))) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Move.class, this.proxy).isRecursive(source, target);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Move files from or into vault requires to pass through encryption features using copy operation");
            }
            return false;
        }
        catch (VaultUnlockCancelException e) {
            return this.proxy.isRecursive(source, target);
        }
    }

    @Override
    public boolean isSupported(Path source, Path target) {
        try {
            if (this.registry.find(this.session, source, false).equals(this.registry.find(this.session, target, false))) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Move.class, this.proxy).isSupported(source, target);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Move files from or into vault requires to pass through encryption features using copy operation");
            }
            return false;
        }
        catch (VaultUnlockCancelException e) {
            return this.proxy.isSupported(source, target);
        }
    }

    @Override
    public Move withDelete(Delete delete) {
        this.proxy.withDelete(delete);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryMoveFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

