/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.VaultCredentials;
import java.util.EnumSet;
import java.util.Objects;

public final class DisabledVault
implements Vault {
    private final Path home;

    public DisabledVault() {
        this(new Path("/", EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume)));
    }

    public DisabledVault(Path home) {
        this.home = home;
    }

    @Override
    public Path create(Session<?> session, String region, VaultCredentials credentials, PasswordStore keychain) throws BackgroundException {
        return null;
    }

    @Override
    public Vault load(Session<?> session, PasswordCallback prompt, PasswordStore keychain) throws BackgroundException {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean contains(Path file) {
        return false;
    }

    @Override
    public Path encrypt(Session<?> session, Path file) throws BackgroundException {
        return file;
    }

    @Override
    public Path encrypt(Session<?> session, Path file, boolean metadata) throws BackgroundException {
        return file;
    }

    @Override
    public Path decrypt(Session<?> session, Path file) throws BackgroundException {
        return file;
    }

    @Override
    public long toCiphertextSize(long cleartextFileSize) {
        return cleartextFileSize;
    }

    @Override
    public long toCleartextSize(long ciphertextFileSize) {
        return ciphertextFileSize;
    }

    @Override
    public <T> T getFeature(Session<?> session, Class<T> type, T delegate) {
        return delegate;
    }

    @Override
    public Vault.State getState() {
        return Vault.State.closed;
    }

    @Override
    public Path getHome() {
        return this.home;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisabledVault that = (DisabledVault)o;
        return Objects.equals(this.home, that.home);
    }

    public int hashCode() {
        return Objects.hash(this.home);
    }
}

