/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionRefusedException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.exception.SSLNegotiateException;
import ch.cyberduck.core.threading.FailureDiagnostics;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.log4j.Logger;

public final class DefaultFailureDiagnostics
implements FailureDiagnostics<BackgroundException> {
    private static final Logger log = Logger.getLogger(DefaultFailureDiagnostics.class);

    @Override
    public FailureDiagnostics.Type determine(BackgroundException failure) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Determine cause for failure %s", failure));
        }
        if (failure instanceof ConnectionTimeoutException) {
            return FailureDiagnostics.Type.network;
        }
        if (failure instanceof ConnectionRefusedException) {
            return FailureDiagnostics.Type.network;
        }
        if (failure instanceof ResolveFailedException) {
            return FailureDiagnostics.Type.network;
        }
        if (failure instanceof SSLNegotiateException) {
            return FailureDiagnostics.Type.application;
        }
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
            if (cause instanceof SSLException) {
                return FailureDiagnostics.Type.network;
            }
            if (cause instanceof NoHttpResponseException) {
                return FailureDiagnostics.Type.network;
            }
            if (cause instanceof ConnectTimeoutException) {
                return FailureDiagnostics.Type.network;
            }
            if (!(cause instanceof SocketException) && !(cause instanceof TimeoutException) && !(cause instanceof SocketTimeoutException) && !(cause instanceof UnknownHostException)) continue;
            return FailureDiagnostics.Type.network;
        }
        return FailureDiagnostics.Type.application;
    }
}

