/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class ThreadLocalHostnameDelegatingTrustManager
implements X509TrustManager,
TrustManagerHostnameCallback {
    private final ThreadLocal<String> target = new ThreadLocal();
    private final X509TrustManager delegate;

    public ThreadLocalHostnameDelegatingTrustManager(X509TrustManager delegate, String hostname) {
        this.delegate = delegate;
        this.setTarget(hostname);
    }

    @Override
    public X509TrustManager init() throws IOException {
        this.delegate.init();
        return this;
    }

    @Override
    public void verify(String hostname, X509Certificate[] certs, String cipher) throws CertificateException {
        this.delegate.verify(hostname, certs, cipher);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String cipher) throws CertificateException {
        this.delegate.verify(this.target.get(), certs, cipher);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String cipher) throws CertificateException {
        this.delegate.verify(this.target.get(), certs, cipher);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    @Override
    public String getTarget() {
        return this.target.get();
    }

    public void setTarget(String hostname) {
        this.target.set(hostname);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThreadLocalHostnameDelegatingTrustManager{");
        sb.append("target=").append(this.target);
        sb.append(", delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

