/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.dd;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.serializer.Reader;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public abstract class PlistReader<S extends Serializable>
implements Reader<S> {
    private static final Logger log = Logger.getLogger(PlistReader.class);

    @Override
    public Collection<S> readCollection(Local file) throws AccessDeniedException {
        Collection<S> c = new Collection<S>();
        NSArray list = (NSArray)this.parse(file);
        if (null == list) {
            log.error((Object)String.format("Invalid bookmark file %s", file));
            return c;
        }
        for (int i = 0; i < list.count(); ++i) {
            NSDictionary dict;
            S object;
            NSObject next = list.objectAtIndex(i);
            if (!(next instanceof NSDictionary) || null == (object = this.deserialize(dict = (NSDictionary)next))) continue;
            c.add(object);
        }
        return c;
    }

    @Override
    public S read(Local file) throws AccessDeniedException {
        if (!file.exists()) {
            throw new LocalAccessDeniedException(file.getAbsolute());
        }
        if (!file.isFile()) {
            throw new LocalAccessDeniedException(file.getAbsolute());
        }
        NSDictionary dict = (NSDictionary)this.parse(file);
        if (null == dict) {
            log.error((Object)String.format("Invalid bookmark file %s", file));
            return null;
        }
        return this.deserialize(dict);
    }

    private NSObject parse(Local file) throws AccessDeniedException {
        try {
            return XMLPropertyListParser.parse((InputStream)file.getInputStream());
        }
        catch (PropertyListFormatException | IOException | ParseException | ParserConfigurationException | SAXException e) {
            log.error((Object)String.format("Invalid bookmark file %s", file));
            return null;
        }
    }

    public abstract S deserialize(NSDictionary var1);
}

