/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.library;

import java.io.File;
import org.apache.log4j.Logger;

public final class Native {
    private static final Logger log = Logger.getLogger(Native.class);
    private static final Object lock = new Object();

    private Native() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(String library) {
        Object object = lock;
        synchronized (object) {
            String path = Native.getPath(library);
            try {
                System.load(path);
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                log.warn((Object)String.format("Failed to load %s:%s", path, e.getMessage()), (Throwable)e);
                try {
                    System.loadLibrary(library);
                    return true;
                }
                catch (UnsatisfiedLinkError f) {
                    log.warn((Object)String.format("Failed to load %s:%s", library, e.getMessage()), (Throwable)e);
                    return false;
                }
            }
        }
    }

    protected static String getPath(String name) {
        return new File(String.format("%s/%s", System.getProperty("java.library.path"), Native.getName(name))).getAbsolutePath();
    }

    protected static String getName(String name) {
        return System.mapLibraryName(name);
    }
}

