/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.IOResumeException;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public final class StreamCopier {
    private static final Logger log = Logger.getLogger(StreamCopier.class);
    private final StreamCancelation cancel;
    private final StreamProgress progress;
    private BytecountStreamListener listener = new BytecountStreamListener(new DisabledStreamListener());
    private Integer chunksize = PreferencesFactory.get().getInteger("connection.chunksize");
    private Long offset = 0L;
    private Long limit = -1L;

    public StreamCopier(StreamCancelation cancel, StreamProgress progress) {
        this.cancel = cancel;
        this.progress = progress;
    }

    public StreamCopier withChunksize(Integer chunksize) {
        this.chunksize = chunksize;
        return this;
    }

    public StreamCopier withListener(StreamListener listener) {
        this.listener = new BytecountStreamListener(listener);
        return this;
    }

    public StreamCopier withLimit(Long limit) {
        if (limit > 0L) {
            this.limit = limit;
        }
        return this;
    }

    public StreamCopier withOffset(Long offset) {
        if (offset > 0L) {
            this.offset = offset;
        }
        return this;
    }

    public void transfer(InputStream in, OutputStream out) throws BackgroundException {
        try {
            try {
                if (this.offset > 0L) {
                    StreamCopier.skip(in, this.offset);
                }
                byte[] buffer = new byte[this.chunksize.intValue()];
                long total = 0L;
                int len = this.chunksize;
                if (this.limit > 0L && this.limit < (long)this.chunksize.intValue()) {
                    len = this.limit.intValue();
                }
                while (len > 0 && !this.cancel.isCanceled()) {
                    int read = in.read(buffer, 0, len);
                    if (-1 == read) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("End of file reached with %d bytes read from stream", total));
                        }
                        this.progress.setComplete();
                        break;
                    }
                    this.listener.recv(read);
                    out.write(buffer, 0, read);
                    this.progress.progress(read);
                    this.listener.sent(read);
                    total += (long)read;
                    if (this.limit > 0L) {
                        len = (int)Math.min(this.limit - total, (long)this.chunksize.intValue());
                    }
                    if (this.limit != total) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Limit %d reached reading from stream", this.limit));
                    }
                    this.progress.setComplete();
                }
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
            finally {
                DefaultStreamCloser c = new DefaultStreamCloser();
                c.close(in);
                c.close(out);
            }
        }
        catch (BackgroundException e) {
            long sent = this.listener.getSent();
            this.progress.progress(-sent);
            this.listener.sent(-sent);
            long recv = this.listener.getRecv();
            this.listener.recv(-recv);
            throw e;
        }
        if (this.cancel.isCanceled()) {
            throw new ConnectionCanceledException();
        }
    }

    public static InputStream skip(InputStream in, long offset) throws BackgroundException {
        try {
            long skipped = in.skip(offset);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skipping %d bytes", skipped));
            }
            if (skipped < offset) {
                throw new IOResumeException(String.format("Skipped %d bytes instead of %d", skipped, offset));
            }
            return in;
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

