/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.io.HashAlgorithm;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class Checksum {
    private static final Logger log = Logger.getLogger(Checksum.class);
    public final HashAlgorithm algorithm;
    public final String hash;
    public static final Checksum NONE = new Checksum(null, null);

    public Checksum(HashAlgorithm algorithm, String hash) {
        this.algorithm = algorithm;
        this.hash = hash;
    }

    public String toString() {
        return this.hash;
    }

    public static Checksum parse(String hash) {
        if (StringUtils.isBlank((CharSequence)hash)) {
            return NONE;
        }
        if (hash.matches("[a-fA-F0-9]{32}")) {
            return new Checksum(HashAlgorithm.md5, hash);
        }
        if (hash.matches("[a-fA-F0-9]{40}")) {
            return new Checksum(HashAlgorithm.sha1, hash);
        }
        if (hash.matches("[A-Fa-f0-9]{64}")) {
            return new Checksum(HashAlgorithm.sha256, hash);
        }
        if (hash.matches("[A-Fa-f0-9]{128}")) {
            return new Checksum(HashAlgorithm.sha512, hash);
        }
        if (hash.matches("[a-fA-F0-9]{8}")) {
            return new Checksum(HashAlgorithm.crc32, hash);
        }
        log.warn((Object)String.format("Failure to detect algorithm for checksum %s", hash));
        return NONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checksum checksum = (Checksum)o;
        if (this.algorithm != checksum.algorithm) {
            return false;
        }
        return !(this.hash != null ? !this.hash.equals(checksum.hash) : checksum.hash != null);
    }

    public int hashCode() {
        int result = this.algorithm != null ? this.algorithm.hashCode() : 0;
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        return result;
    }
}

