/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.ProxyCredentialsStore;
import ch.cyberduck.core.ProxyCredentialsStoreFactory;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.impl.auth.win.WindowsCredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.WinHttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class CallbackProxyAuthenticationStrategy
extends ProxyAuthenticationStrategy {
    private static final Logger log = Logger.getLogger(CallbackProxyAuthenticationStrategy.class);
    private static final String PROXY_CREDENTIALS_INPUT_ID = "cyberduck.credentials.input";
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("Negotiate", "Kerberos", "NTLM", "CredSSP", "Digest", "Basic"));
    private static final List<String> IWA_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("Negotiate", "NTLM"));
    private final Preferences preferences = PreferencesFactory.get();
    private final Host bookmark;
    private final LoginCallback prompt;
    private final ProxyCredentialsStore keychain;

    public CallbackProxyAuthenticationStrategy(Host bookmark, LoginCallback prompt) {
        this(ProxyCredentialsStoreFactory.get(), bookmark, prompt);
    }

    public CallbackProxyAuthenticationStrategy(ProxyCredentialsStore keychain, Host bookmark, LoginCallback prompt) {
        this.keychain = keychain;
        this.bookmark = bookmark;
        this.prompt = prompt;
    }

    public Queue<AuthOption> select(Map<String, Header> challenges, HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        Credentials credentials;
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        LinkedList<AuthOption> options = new LinkedList<AuthOption>();
        Lookup registry = clientContext.getAuthSchemeRegistry();
        if (registry == null) {
            return options;
        }
        RequestConfig config = clientContext.getRequestConfig();
        List<String> authPrefs = config.getProxyPreferredAuthSchemes();
        if (authPrefs == null) {
            authPrefs = DEFAULT_SCHEME_PRIORITY;
        }
        if (this.preferences.getBoolean("connection.proxy.windows.authentication.enable") && WinHttpClients.isWinAuthAvailable()) {
            for (String s : IWA_SCHEME_PRIORITY) {
                AuthSchemeProvider provider;
                Header challenge = challenges.get(s.toLowerCase(Locale.ROOT));
                if (challenge == null || (provider = (AuthSchemeProvider)registry.lookup(s)) == null) continue;
                AuthScheme authScheme = provider.create(context);
                authScheme.processChallenge(challenge);
                AuthScope authScope = new AuthScope(authhost.getHostName(), authhost.getPort(), authScheme.getRealm(), authScheme.getSchemeName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Add authentication options for scheme %s", authPrefs));
                }
                options.add(new AuthOption(authScheme, new WindowsCredentialsProvider((CredentialsProvider)(null == clientContext.getCredentialsProvider() ? new BasicCredentialsProvider() : clientContext.getCredentialsProvider())).getCredentials(authScope)));
            }
            if (!options.isEmpty()) {
                return options;
            }
        }
        if (StringUtils.isEmpty((CharSequence)(credentials = this.keychain.getCredentials(authhost.toURI())).getPassword())) {
            try {
                credentials = this.prompt.prompt(this.bookmark, "", String.format("%s %s", LocaleFactory.localizedString("Login", "Login"), authhost.getHostName()), MessageFormat.format(LocaleFactory.localizedString("Login {0} with username and password", "Credentials"), authhost.getHostName()), new LoginOptions().icon(this.bookmark.getProtocol().disk()).usernamePlaceholder(LocaleFactory.localizedString("Username", "Credentials")).passwordPlaceholder(LocaleFactory.localizedString("Password", "Credentials")).user(true).password(true));
                if (credentials.isSaved()) {
                    context.setAttribute(PROXY_CREDENTIALS_INPUT_ID, (Object)credentials);
                }
            }
            catch (LoginCanceledException ignored) {
                throw new MalformedChallengeException(ignored.getMessage(), (Throwable)ignored);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Authentication schemes in the order of preference: %s", authPrefs));
        }
        for (String id : authPrefs) {
            Header challenge = challenges.get(id.toLowerCase(Locale.ROOT));
            if (challenge != null) {
                AuthSchemeProvider authSchemeProvider = (AuthSchemeProvider)registry.lookup(id);
                if (authSchemeProvider == null) continue;
                AuthScheme authScheme = authSchemeProvider.create(context);
                authScheme.processChallenge(challenge);
                options.add(new AuthOption(authScheme, (org.apache.http.auth.Credentials)new NTCredentials(credentials.getUsername(), credentials.getPassword(), this.preferences.getProperty("webdav.ntlm.workstation"), this.preferences.getProperty("webdav.ntlm.domain"))));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("Challenge for %s authentication scheme not available", id));
        }
        return options;
    }

    public void authSucceeded(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        Credentials credentials = (Credentials)clientContext.getAttribute(PROXY_CREDENTIALS_INPUT_ID, Credentials.class);
        if (null != credentials) {
            clientContext.removeAttribute(PROXY_CREDENTIALS_INPUT_ID);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Save passphrase for proxy %s", authhost));
            }
            this.keychain.addCredentials(authhost.toURI(), credentials.getUsername(), credentials.getPassword());
        }
        super.authSucceeded(authhost, authScheme, context);
    }

    public void authFailed(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        this.keychain.deleteCredentials(authhost.getHostName());
        super.authFailed(authhost, authScheme, context);
    }
}

