/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import org.apache.commons.lang3.StringUtils;

public enum Scheme {
    ftp{

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public int getPort() {
            return 21;
        }
    }
    ,
    ftps{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public int getPort() {
            return 21;
        }
    }
    ,
    sftp{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public int getPort() {
            return 22;
        }
    }
    ,
    scp{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public int getPort() {
            return 22;
        }
    }
    ,
    http{

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public int getPort() {
            return 80;
        }
    }
    ,
    https{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public int getPort() {
            return 443;
        }
    }
    ,
    dav{

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public int getPort() {
            return 80;
        }
    }
    ,
    davs{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public int getPort() {
            return 443;
        }
    }
    ,
    s3{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public int getPort() {
            return 443;
        }
    }
    ,
    rtmp{

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public int getPort() {
            return 1935;
        }
    }
    ,
    udt{

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public int getPort() {
            return 4280;
        }
    }
    ,
    udts{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public int getPort() {
            return 42443;
        }
    }
    ,
    irods{

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public int getPort() {
            return 1247;
        }
    }
    ,
    file{

        @Override
        public boolean isSecure() {
            return true;
        }

        @Override
        public int getPort() {
            return 0;
        }
    };


    public abstract boolean isSecure();

    public abstract int getPort();

    public static boolean isURL(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            for (Scheme scheme : Scheme.values()) {
                if (scheme.equals((Object)file) || !str.startsWith((Object)((Object)scheme) + "://")) continue;
                return true;
            }
        }
        return false;
    }
}

