/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Objects;

public final class LoginOptions {
    public boolean user = true;
    public boolean password = true;
    public boolean keychain = true;
    public boolean save = PreferencesFactory.get().getBoolean("connection.login.keychain");
    public boolean publickey = false;
    public boolean certificate = false;
    public boolean anonymous = false;
    public String icon;
    public String usernamePlaceholder = "";
    public String passwordPlaceholder = "";

    public LoginOptions() {
    }

    public LoginOptions(LoginOptions copy) {
        this.user = copy.user;
        this.password = copy.password;
        this.keychain = copy.keychain;
        this.save = copy.save;
        this.publickey = copy.publickey;
        this.certificate = copy.certificate;
        this.anonymous = copy.anonymous;
        this.icon = copy.icon;
        this.usernamePlaceholder = copy.usernamePlaceholder;
        this.passwordPlaceholder = copy.passwordPlaceholder;
    }

    public LoginOptions user(boolean e) {
        this.user = e;
        return this;
    }

    public LoginOptions password(boolean e) {
        this.password = e;
        return this;
    }

    public LoginOptions keychain(boolean e) {
        this.keychain = e;
        if (!this.keychain) {
            this.save = false;
        }
        return this;
    }

    public LoginOptions publickey(boolean e) {
        this.publickey = e;
        return this;
    }

    public LoginOptions anonymous(boolean e) {
        this.anonymous = e;
        return this;
    }

    public LoginOptions icon(String icon) {
        this.icon = icon;
        return this;
    }

    public LoginOptions save(boolean save) {
        this.save = save;
        return this;
    }

    public boolean user() {
        return this.user;
    }

    public boolean password() {
        return this.password;
    }

    public boolean keychain() {
        return this.keychain;
    }

    public boolean publickey() {
        return this.publickey;
    }

    public boolean certificate() {
        return this.certificate;
    }

    public boolean anonymous() {
        return this.anonymous;
    }

    public String icon() {
        return this.icon;
    }

    public boolean save() {
        return this.save;
    }

    public LoginOptions usernamePlaceholder(String usernamePlaceholder) {
        this.usernamePlaceholder = usernamePlaceholder;
        return this;
    }

    public LoginOptions passwordPlaceholder(String passwordPlaceholder) {
        this.passwordPlaceholder = passwordPlaceholder;
        return this;
    }

    public String getUsernamePlaceholder() {
        return this.usernamePlaceholder;
    }

    public String getPasswordPlaceholder() {
        return this.passwordPlaceholder;
    }

    public LoginOptions(Protocol protocol) {
        this.configure(protocol);
    }

    public void configure(Protocol protocol) {
        this.publickey = protocol.isPrivateKeyConfigurable();
        this.certificate = protocol.isCertificateConfigurable();
        this.anonymous = protocol.isAnonymousConfigurable();
        this.user = protocol.isUsernameConfigurable();
        this.password = protocol.isPasswordConfigurable();
        this.icon = protocol.disk();
        this.usernamePlaceholder = protocol.getUsernamePlaceholder();
        this.passwordPlaceholder = protocol.getPasswordPlaceholder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginOptions that = (LoginOptions)o;
        return this.user == that.user && this.password == that.password && this.keychain == that.keychain && this.publickey == that.publickey && this.anonymous == that.anonymous && Objects.equals(this.icon, that.icon);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.password, this.keychain, this.publickey, this.anonymous, this.icon);
    }
}

